
import Foundation

func calculate() -> String {
   let length = Measurement(value: 40, unit: UnitLength.kilometers)
   let chinaLocale = Locale(identifier: "zh_CN")
   var format = Measurement<UnitLength>.FormatStyle(width: .wide, locale: chinaLocale, usage: .asProvided)
   let text = length.formatted(format)
   return text
}
print(calculate())  // "40.00公里"
